% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indicators.R
\name{ml_hhaccess}
\alias{ml_hhaccess}
\title{ML_ITNA_P_ACC
Households with at least one insecticide-treated mosquito net (ITN) for every two persons who stayed in the household the previous night
Persons with access to an insecticide-treated mosquito net (ITN)
ML_NETS_HH.do  HR
Households with >1 ITN per 2 household members
Percentage of households with at least one ITN for every 2 persons who stayed in the household last night}
\usage{
ml_hhaccess(Rdata)
}
\arguments{
\item{Rdata}{data.frame from survryPrev::getDHSdata}
}
\value{
A partially processed data.frame that will be used in  survryPrev::getDHSindicator. The whole function can be used as a parameter in survryPrev::getDHSindicator
}
\description{
ML_ITNA_P_ACC
Households with at least one insecticide-treated mosquito net (ITN) for every two persons who stayed in the household the previous night
Persons with access to an insecticide-treated mosquito net (ITN)
ML_NETS_HH.do  HR
Households with >1 ITN per 2 household members
Percentage of households with at least one ITN for every 2 persons who stayed in the household last night
}
\examples{
\dontrun{
dhsData <- getDHSdata(country = "Zambia",
                                 indicator = "ML_ITNA_P_ACC",
                                 year = 2018)
data <- getDHSindicator(dhsData, indicator = NULL,
                         FUN = surveyPrev::ml_hhaccess)
}
}
\author{
Qianyu Dong
}
