% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmst2perm.R
\name{rmst2perm}
\alias{rmst2perm}
\title{Permutation Test for Comparing Restricted Mean Survival Time}
\usage{
rmst2perm(time, status, arm, tau=NULL, mperm=c(1:6), nperm=100000,
seed=NULL, asy="greenwood", test="2_side")
}
\arguments{
\item{time}{The follow-up time for right censored data.}

\item{status}{The event indicator, 1=event, and 0=censor.}

\item{arm}{The group indicator for comparison with a value of either 0 or 1. Normally, 0=control group, 1=active treatment group. The three vectors (\code{time}, \code{status}, \code{arm}) need to have the same length.}

\item{tau}{A scaler value to specify the truncation time point for the RMST calculation.
It needs to be smaller than the minimum value of the largest observed time in each of the two groups.}

\item{mperm}{A vector with the numbers from 1 to 6 to specify the method for conducting the permutation test when the last observation time from either group does not reach the specified \code{tau}.
It supports: 1=ignoring the inestimable cases (Method 1),
2=extending the survival curve to tau (Method 2),
3=switching the last censored observation to the event observation (Method 3),
4=averaging RMSTs derived from Methods 2 and 3 (Method 4),
5=fitting a Weibull distribution to each inestimable case (Method 5), and
6=utilizing pseudo-observations (Method 6). Please see Horiguchi and Uno (2020) <doi:10.1002/sim.8565> for details.}

\item{nperm}{The number of iterations for the resampling. It is recommended to specify at least 100,000 (default) or larger.}

\item{seed}{An integer value, used for random number generation in the resampling procedure. Default is \code{NULL}.}

\item{asy}{Specify the asymptotic variance estimator for the difference in RMST.
\code{asy} supports \code{"greenwood"} for Greenwood plug-in estimator (default) and \code{"aj"} for Aalen-Johansen plug-in estimators. Please see Horiguchi and Uno (2020) <doi:10.1002/sim.8565> for details.}

\item{test}{Specify \code{"1_side"} for the one-sided test where the alternative hypothesis is that the treatment effect in arm=1 is superior to that in arm=0 with respect to survival.
Specify \code{"2_side"} for the two-sided test where the alternative hypothesis is that the treatment effect in arm=1 is not equal to that in arm=0 with respect to survival.
Default is \code{"2_side"}.}
}
\value{
An object of class rmst2perm.

\item{point_estimate}{Estimated RMST values for arm=1, arm=0, and their difference}

\item{asymptotic_test_pval}{P-value of the asymptotic test for the difference in RMST}

\item{permutation_test_methodX_pval}{P-value of the permutation test for the difference in RMST using Method X (X is the number specified in \code{mperm})}

\item{methodX_number_applied}{The number of times Method X was applied during the permutation process. (X is the number specified in \code{mperm} except 6.) For X=1 (Method 1), this returns how many additional permutations were performed in order to obtain \code{nperm} of realizations.}

\item{method5_number_exponential_used}{The number of times the exponential distribution was used for the parametric fit during the permutations. Normally, the Weibull distribution is used for Method 5.
However, when the maximum likelihood estimate (MLE) for the Weibull distribution cannot be derived or the hessian of the covariance matrix for the MLE is singular, the exponential distribution will be used.}

\item{tau}{The truncation time used in the analysis}

\item{mperm}{The method used to conduct the permutation test}

\item{nperm}{The number of iterations for the resampling}

\item{asy}{The type of the asymptotic variance estimator used for the asymptotic test}

\item{test}{The type of test used in the analysis}
}
\description{
Performs the permutation test using difference in the restricted mean
survival time (RMST) between groups as a summary measure of the survival time distribution.
When the sample size is less than 50 per group, it has been shown that there is non-negligible
inflation of the type I error rate in the commonly used asymptotic test for the RMST comparison.
Generally, permutation tests can be useful in such a situation.
However, when we apply the permutation test for the RMST comparison, particularly in small sample
situations, there are some cases where the survival function in either group cannot be defined
due to censoring in the permutation process. Horiguchi and Uno (2020) <doi:10.1002/sim.8565>
have examined six workable solutions to handle this numerical issue.
It performs permutation tests with implementation of the six methods outlined in the paper
when the numerical issue arises during the permutation process.
The result of the asymptotic test is also provided for a reference.
}
\examples{
#--- sample data ---#
D      = rmst2perm.sample.data()
time   = D$time
status = D$status
arm    = D$arm
tau    = 34
mperm  = c(1:6)
nperm  = 100 #--This number is only for the example.
             #--It is recommended to specify at least 100K (default) or larger.
seed   = 123

a = rmst2perm(time=time, status=status, arm=arm,
              tau=tau, mperm=mperm, nperm=nperm, seed=seed)
print(a)
}
\references{
Horiguchi M, Uno H. On permutation tests for comparing restricted mean survival time
with small sample from randomized trials. Statistics in Medicine 2020. doi:10.1002/sim.8565.
}
\author{
Miki Horiguchi, Hajime Uno
}
