% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oneGroupOneEvent.R
\name{extractOneGroupOneEvent}
\alias{extractOneGroupOneEvent}
\title{Extracts one group and one event of a survfit model as a data frame.}
\usage{
extractOneGroupOneEvent(model, group = NA, event = NA, firstRow = TRUE)
}
\arguments{
\item{model}{A survfit object.}

\item{group}{Number of the chosen group. If the model-object has only one
Strata (Group), this parameter can be NA.}

\item{event}{If the model-object is a multistate-model, the event-type
needs to be specified, otherwise it can be NA.}

\item{firstRow}{Typically, a survfit-model does not include data of time=0,
if true this function tries to add a column time=0 as a first row.}
}
\value{
Returns a data frame with the times, estimate, upper and lower CI and
the n.Risk of one group and one event of a Kaplan Meier estimator or a 
competitive risk analysis
}
\description{
This function is a helper function for the package and is not exported.
}
