% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semivariogram.R
\name{semivariogram}
\alias{semivariogram}
\alias{semivariogram.data.frame}
\alias{semivariogram.stars}
\alias{autoplot.semivariogramobj}
\title{Computes the semi-variogram using a dataframe or a stars object.}
\usage{
semivariogram(
  x,
  latitude_linear = TRUE,
  longitude_linear = TRUE,
  missing_value = -9999,
  width = 80,
  cutoff = 1000,
  tlagmax = 6,
  ...
)

\method{semivariogram}{data.frame}(
  x,
  latitude_linear = TRUE,
  longitude_linear = TRUE,
  missing_value = -9999,
  width = 80,
  cutoff = 1000,
  tlagmax = 6,
  times_df,
  values_df,
  ...
)

\method{semivariogram}{stars}(
  x,
  latitude_linear = TRUE,
  longitude_linear = TRUE,
  missing_value = -9999,
  width = 80,
  cutoff = 1000,
  tlagmax = 6,
  ...
)

\method{autoplot}{semivariogramobj}(object, ...)
}
\arguments{
\item{x}{The dataframe or stars object. If it is a dataframe, then it should have the locations.}

\item{latitude_linear}{If \code{TRUE}  a linear model is fitted with latitude as a covariate is fitted.}

\item{longitude_linear}{If \code{TRUE}  a linear model is fitted with longitude as a covariate is fitted.}

\item{missing_value}{If a certain value such as -9999 denotes the missing values for given locations and times.}

\item{width}{A parameter to the \code{gstat::variogram} function. The width of the distance intervals to be considered.}

\item{cutoff}{A parameter to the \code{gstat::variogram} function. The spatial separation distance.}

\item{tlagmax}{A parameter to the \code{gstat::variogram} function. The maximum time lag.}

\item{...}{Other arguments that need to be used for datafames  or currently ignored.}

\item{times_df}{For dataframes: the dataframe containing the dates in \code{Date} format.}

\item{values_df}{For dataframes: the dataframe of dimension \code{length(times) x length(locations)} containing the quantity of interest.}

\item{object}{For autoplot: the output from the semivariogram function.}
}
\value{
A semivariogram object with a gstat variogram and the original data.
}
\description{
Computes the semi-variogram from a stars or a dataframe. Input arguments differ
for each case. Function autoplot can plot the output.

When the input is a dataframe, the locations, time and the quantity of interest needs to
be given. When the input is a stars object, a 3 dimensional stars object needs to be given
as input with the first 2 dimensions being spatial and the third being time.
}
\examples{
# Dataframe example
library(dplyr)
data(locs)
data(Times)
data(Tmax)
temp_part <- with(Times, paste(year, month, day, sep = "-"))
temp_part <- data.frame(date = as.Date(temp_part)[913:923])
Tmax <- Tmax[913:923, ]
semidf <- semivariogram(locs,
        temp_part,
        Tmax,
        latitude_linear = FALSE,
        longitude_linear = FALSE,
        missing_value = -9999,
        width = 50,
        cutoff = 1000,
        tlagmax = 7
)
autoplot(semidf)

# Stars example
library(stars)
# Create a stars object from a data frame
precip_df <- NOAA_df_1990[NOAA_df_1990$proc == 'Precip', ] \%>\%
  filter(date >= "1992-02-01" & date <= "1992-02-05")
precip <- precip_df[ ,c('lat', 'lon', 'date', 'z')]
st_precip <- st_as_stars(precip, dims = c("lon", "lat", "date"))
semist <- semivariogram(st_precip)
autoplot(semist)

}
