% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ridgeline.R
\name{ridgeline}
\alias{ridgeline}
\alias{ridgeline.data.frame}
\alias{ridgeline.stars}
\title{Ridgeline plots grouped by an attribute using a dataframe as an input.}
\usage{
ridgeline(
  x,
  num_grps = 10,
  xlab = "Value",
  ylab = "Group Intervals",
  title = "",
  legend_title = "z",
  ...
)

\method{ridgeline}{data.frame}(
  x,
  num_grps = 10,
  xlab = "Value",
  ylab = "Group Intervals",
  title = "",
  legend_title = "z",
  group_col,
  z_col,
  ...
)

\method{ridgeline}{stars}(
  x,
  num_grps = 10,
  xlab = "Value",
  ylab = "Group Intervals",
  title = "",
  legend_title = "z",
  group_dim,
  ...
)
}
\arguments{
\item{x}{A stars object or a dataframe. Arguments differ according to the input type.}

\item{num_grps}{The number of levels for the ridgeline plot.}

\item{xlab}{The x label.}

\item{ylab}{The y label.}

\item{title}{The graph title.}

\item{legend_title}{The title for the legend.}

\item{...}{Other arguments currently ignored.}

\item{group_col}{For dataframes: the column name of the group column.}

\item{z_col}{For dataframes: the The quantity of interest that will be plotted. Eg. temperature.}

\item{group_dim}{For stars objects: the dimension for the grouping variable.}
}
\value{
A ggplot object.
}
\description{
Plots ridgeline plots grouped by latitude/longitude or time.
This function can take either a stars object or a dataframe.
Input arguments differ for each case.
}
\examples{
# Dataframe example
library(dplyr)
data(NOAA_df_1990)
TmaxJan <- filter(NOAA_df_1990,
                 proc == "Tmax" &
                 year == 1993 &
                 month == 1)
ridgeline(TmaxJan,
      group_col = 'lat',
      z_col = 'z',
      xlab = 'Maximum Temperature',
      ylab = 'Latitude Intervals')

# stars examples
library(stars)
library(units)

# stars Example 1
tif = system.file("tif/olinda_dem_utm25s.tif", package = "stars")
x <- read_stars(tif)
dim(x)
ridgeline(x, group_dim = 1)
ridgeline(x, group_dim = 2)


# stars Example 2
tif = system.file("tif/lc.tif", package = "stars")
x <- read_stars(tif)
ridgeline(x, group_dim = 1)
ridgeline(x, group_dim = 2)

}
