% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canonical_correlation.R
\name{canonical_correlation}
\alias{canonical_correlation}
\alias{canonical_correlation.data.frame}
\alias{canonical_correlation.stars}
\alias{autoplot.cancor}
\title{Computes transformed variables from Canonical Correlation Analysis using a dataframe or a stars object}
\usage{
canonical_correlation(x1, x2, ...)

\method{canonical_correlation}{data.frame}(x1, x2, ...)

\method{canonical_correlation}{stars}(x1, x2, ...)

\method{autoplot}{cancor}(object, xlab = "Time", ...)
}
\arguments{
\item{x1}{The first dataframe or stars object.}

\item{x2}{The second dataframe or stars objext. The dimensions of both datasets need to be the same.}

\item{...}{Other arguments currently ignored.}

\item{object}{For autoplot: the output of the function `cannonical_correlation'.}

\item{xlab}{For autoplot: the xlabel to appear on CCA plot.}
}
\value{
A canonical correlation object.
}
\description{
Computes Canonical Correlation Analysis (CCA) using 2 datasets. The autoplot function
plots the output.
}
\examples{
# Dataframe example
df1 <- SSTdatashort[1:100, ]
df2 <- SSTdatashort[401:500, ]
ccor <- canonical_correlation(df1, df2)
autoplot(ccor)

# stars example
library(stars)
tif = system.file("tif/olinda_dem_utm25s.tif", package = "stars")
x <- read_stars(tif)
x1 <- x[[1]][1:50, 1:50]
x2 <- x[[1]][51:100, 1:50]
stx1 <- st_as_stars(x1)
stx2 <- st_as_stars(x2)
canonical_correlation(stx1, stx2)

}
