% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ljust.R
\name{strs_ljust}
\alias{strs_ljust}
\title{Left-justify string in a field of a given width}
\usage{
strs_ljust(string, width, fillchar = " ")
}
\arguments{
\item{string}{A character vector where each element is a string to be
left-justified.}

\item{width}{The total width of the field in which the string is to be
left-justified.}

\item{fillchar}{A character used for padding on the right.}
}
\value{
A character vector of the same length as \code{string}, with each element
left-justified in a field of the specified width.
}
\description{
\code{strs_ljust} left-justifies each element of a character vector in a field of
a specified width. It is similar to Python's \code{str.ljust()} method.
}
\examples{
strs_ljust("hello", 10)
strs_ljust("world", 10, "*")
}
\seealso{
\href{https://docs.python.org/3/library/stdtypes.html#str.ljust}{Python str.ljust() documentation}
}
