% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bed_thickness.R
\name{bed_thickness}
\alias{bed_thickness}
\title{extract bed thicknesses}
\usage{
bed_thickness(s)
}
\arguments{
\item{s}{stratigraphic column (a \code{stratcol} object)}
}
\value{
a numeric vector of bed thicknesses
}
\description{
extracts bed thicknesses from stratigraphic column
}
\examples{
s = as_stratcol(c(0.5, 1, 0.3, 0.7), c("sand", "shale", "sand", "shale"), L_unit = "m")
thickness = bed_thickness(s)
hist(thickness, main = "Bed thickness", xlab = paste0("Thickness (m)"))


}
