% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{asummary}
\alias{asummary}
\title{Summarizing the Allocation}
\usage{
asummary(x, A, m = NULL, M = NULL)
}
\arguments{
\item{x}{(\code{numeric})\cr sample allocations \eqn{x_1,\ldots,x_H} in strata.}

\item{A}{(\code{numeric})\cr population constants \eqn{A_1,\ldots,A_H}.}

\item{m}{(\code{numeric} or \code{NULL})\cr lower bounds \eqn{m_1,\ldots,m_H},
optionally imposed on sample sizes in strata.}

\item{M}{(\code{numeric} or \code{NULL})\cr upper bounds \eqn{M_1,\ldots,M_H},
optionally imposed on sample sizes in strata.}
}
\value{
A \code{\link{data.frame}} with as many rows as number of strata \eqn{H} + 1,
and up to 7 variables. A single row corresponds to a given stratum
\eqn{h \in \{1,\ldots,H\}}, whilst the last row contains sums of all of the
numerical values from the above rows (wherever feasible).
Summary table has the following columns (* indicates that the column may
not be present):
\describe{
\item{A}{population constant \eqn{A_h}}
\item{m*}{lower bound imposed on sample size in stratum}
\item{M*}{upper bound imposed on sample size in stratum}
\item{allocation}{sample size for a given stratum}
\item{take_min*}{indication whether the allocation is of \code{take-min} type,
i.e. \eqn{x_h = m_h}}
\item{take_max*}{indication whether the allocation is of \code{take-max} type,
i.e. \eqn{x_h = M_h}}
\item{take_Neyman}{indication whether the allocation is of \code{take-Neyman}
type, i.e. \eqn{m_h < x_h < M_h}}
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

A helper function that returns a simple \code{\link{data.frame}} with summary of the
allocation as returned by the \code{\link[=opt]{opt()}} or \code{\link[=optcost]{optcost()}}. See the illustrate
example below.
}
\examples{
A <- c(3000, 4000, 5000, 2000)
m <- c(100, 90, 70, 80)
M <- c(200, 150, 300, 210)

xopt_1 <- opt(n = 400, A, m)
asummary(xopt_1, A, m)

xopt_2 <- opt(n = 540, A, m, M)
asummary(xopt_2, A, m, M)
}
\seealso{
\code{\link[=opt]{opt()}}, \code{\link[=optcost]{optcost()}}.
}
