% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/21_shareValConstantG.R
\name{shareValConstantG}
\alias{shareValConstantG}
\title{Calculates the share value from total Equity Value (based on single stage constant growth) that is divided by number of outstanding shares.}
\usage{
shareValConstantG(FCFE0, g, WACC, shares)
}
\arguments{
\item{FCFE0}{A number.}

\item{g}{A number.}

\item{WACC}{A number.}

\item{shares}{A number.}
}
\value{
Input values to four arguments  \code{FCFE0} \code{g}, \code{WACC}, and \code{shares}.
}
\description{
Calculates the share value from total Equity Value (based on single stage constant growth) that is divided by number of outstanding shares.
}
\details{
According to information provided by Jerald E. Pinto (2020), the method \code{shareValConstantG} is developed to compute estimated value of the equity when FCFE is growing at a constant rate for the values passed to its three arguments. Here, \code{FCFE0} is given amount of future Free Cash Flow to the Equity in millions of dollars, \code{g} is constant rate of growth under single stage constant growth model, \code{WACC} is Weighted Average Cost of Capital, and \code{shares} is number of shares in millions.
}
\examples{
shareValConstantG(FCFE0=1.8,g=0.08,WACC=0.12,shares=1.5 )
shareValConstantG(FCFE0=700,g=0.05,WACC=0.102,shares=200)
}
\references{
Pinto, J. E. (2020). Equity Asset Valuation (4th ed.). Wiley Professional Development (P&T). https://bookshelf.vitalsource.com/books/9781119628194
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
