% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/09_computingRwithGGM.R
\name{computingRwithGGM}
\alias{computingRwithGGM}
\title{Calculates Required Rate of Return using the Gordon Growth Model.}
\usage{
computingRwithGGM(divN1, g, spNot)
}
\arguments{
\item{divN1}{A number.}

\item{g}{A number.}

\item{spNot}{A number.}
}
\value{
Input values to three arguments  \code{divN1} , \code{g} and \code{spNot}.
}
\description{
Under the assumption of efficient prices, the Gordon growth model has been used to estimate a stock’s required rate of return, or equivalently, the market-price-implied expected return (Jerald E. Pinto, 2020).
}
\details{
According to information provided by Jerald E. Pinto (2020), the method \code{computingRwithGGM} is developed for computing Required Rate of Return using the Gordon Growth Model for the values passed to its three arguments. Here, \code{divN1} is dollar value of the dividend in one year, \code{g} is dividend growth rate, and \code{spNot} is current share price.
}
\examples{
computingRwithGGM(divN1=2.363,g=0.055,spNot=56.60)
}
\references{
Pinto, J. E. (2020). Equity Asset Valuation (4th ed.). Wiley Professional Development (P&T). https://bookshelf.vitalsource.com/books/9781119628194
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
