% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{circ.bootstrap}
\alias{circ.bootstrap}
\title{Bootstrap for circdiff}
\usage{
circ.bootstrap(est, theta, boot_iter=500, p=0.05, seed = NULL)
}
\arguments{
\item{est}{object of class \code{cbm} or \code{vmp}}

\item{theta}{data of the discretely observed diffusion}

\item{boot_iter}{number of bootstrap iteration (Default is 500)}

\item{p}{1-p\% confidence interval (Default is 0.05)}

\item{seed}{(optional) seed value}
}
\value{
Returns a matrix of the bootstrap (1-p)\% confidence interval for the parameters. The first row is the lower bound and the second
row is the upper bound.
}
\description{
\code{stoch.bootstrap} returns the Bootstrap confidence interval for estimated parameters from \code{circdiff}.
}
\details{
This function returns a (1-p)\% confidence interval for estimated parameters from \code{circdiff}
using parametric bootstrap. See section 4 of Majumdar and Laha (2024) \url{doi:10.48550/arXiv.2412.06343}.
}
\examples{
\donttest{
library(stochcorr)


data(wind)

if(requireNamespace("ggplot2")){
library(ggplot2)
ggplot2::ggplot(wind, aes(x = Date, y = Dir)) +
  geom_line() +
  labs(title = "Sotavento Wind Farm",
       x = "Date",
       y = "Wind Direction") +
  scale_x_datetime(date_labels = "\%d-\%b", date_breaks = "2 day") +
  theme_test() +
  theme(
    text = element_text(size = 15),
    axis.text.x = element_text(angle = 90, hjust = 1)
  )
}

a<-circdiff(wind$Dir,10/1440,"vmp")
a

b<-circdiff(wind$Dir,10/1440,"cbm")
b



estimates_vmp<-circ.bootstrap(a,wind$Dir, seed = 100)
estimates_vmp

estimates_cbm<-circ.bootstrap(b,wind$Dir, seed = 100)
estimates_cbm}
}
\seealso{
\code{\link[=circdiff]{circdiff()}}
}
