% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effect_size.R
\name{effect_size}
\alias{effect_size}
\title{Quantifies the relative effect sizes of each component of zmgcv` GAM model.}
\usage{
effect_size(mgcv_model, digits = 3)
}
\arguments{
\item{mgcv_model}{a GAM model created by the \code{mgcv} package}

\item{digits}{the number of significant figures of uysed to report effect size}
}
\value{
a matrix of the model terms, the size of the effect (range) ad standard deviation (sd)
}
\description{
Quantifies the relative effect sizes of each component of zmgcv` GAM model.
}
\examples{
require(dplyr)
require(stringr)
require(purrr)
require(doParallel)

# define input data
data("chaco")
m <- gam(
ndvi ~
  te(X,Y, by = tmax) +
  s(X,Y, by = pr),
 data = chaco,
 method = "REML",
 family = gaussian()
)
# examine the effect size
effect_size(m, 3)
}
