% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_data.R
\name{load_data}
\alias{load_data}
\title{Load and format data object}
\usage{
load_data(
  time,
  cluster_id,
  individual_id = NULL,
  treatment,
  outcome,
  time_type = "discrete",
  data
)
}
\arguments{
\item{time}{A character string; the name of the numeric variable representing
time. Time can be either discrete or continuous.}

\item{cluster_id}{A character string; the name of the numeric variable
identifying the cluster.}

\item{individual_id}{A character string (optional); the name of the numeric
variable identifying the individual.}

\item{treatment}{A character string; the name of the binary variable
indicating treatment. Values must be either integers (0/1) or Boolean
(T/F).}

\item{outcome}{Either a character string or a vector of two character strings;
for a numeric or binary outcome, the single character string indicates
the name of the numeric or binary outcome variable; for binomial outcome
data, the vector of two character strings indicates the "# of successes"
variable and the "# of trials" variable, respectively. Values in the
outcome variable(s) must be either numeric or Boolean (T/F).}

\item{time_type}{One of c("discrete", "continuous"); whether the model treats
time as discrete or continuous.}

\item{data}{A dataframe containing the stepped wedge trial data.}
}
\value{
An object of class \code{sw_data}
}
\description{
Load and format data object
}
\examples{
example_data <- load_data(time ="period", cluster_id = "cluster", individual_id = NULL,
treatment = "trt", outcome = "outcome_cont", data = sw_data_example)
base::summary(example_data)


}
