% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mirandom.R
\name{mirandom}
\alias{mirandom}
\title{Convert target/decoy scores into winning scores and labels}
\usage{
mirandom(scores, c = 0.5, lambda = 0.5)
}
\arguments{
\item{scores}{An m x (d + 1) matrix where m is the number of hypothesis and
d is the number of decoy scores for each hypothesis. The first column of
\code{scores} are target scores and subsequent columns are decoy scores.}

\item{c}{Determines the ranks of the target score that are considered
winning. Defaults to \code{c = 0.5} for single-decoy FDP-SD.}

\item{lambda}{Determines the ranks of the target score that are
considered losing. Defaults to \code{lambda = 0.5} for single-decoy FDP-SD.}
}
\value{
A m x 2 matrix where m is the number of hypotheses. The first column
contains the winning scores and the second column contains the corresponding
labels.
}
\description{
\code{mirandom} takes a collection of target and decoy scores for m
hypotheses and returns a winning score and label attached to each.
The argument \code{scores} must be organised in an m x (d + 1) matrix,
where d is the number of decoy scores. The first column of \code{scores}
must contain the target scores.
}
\examples{
target_scores <- rnorm(200, mean = 1.5)
decoy_scores <- matrix(rnorm(600, mean = 0), ncol = 3)
scores <- cbind(target_scores, decoy_scores)
mirandom(scores)
}
