% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codelists.R
\name{sp_add_codelist}
\alias{sp_add_codelist}
\title{Add codelist data to downloaded data}
\usage{
sp_add_codelist(
  data,
  codelist = NULL,
  period_column = .data$vykaz_date,
  by = NULL,
  redownload = FALSE,
  dest_dir = NULL
)
}
\arguments{
\item{data}{a data frame returned by \code{sp_get_table()}.}

\item{codelist}{The codelist to add. Either a character vector of length one (see \code{sp_tables} for possible values), or a data frame returned by \code{sp_get_codelist()}.}

\item{period_column}{Unquoted column name of column identifying the data period in \code{data}. Leave to default if you have not changed the \code{data} object returned by \code{sp_get_table()}.}

\item{by}{character. Columns by which to join the codelist. Same form as for \verb{dplyr::left_join()``.}.}

\item{redownload}{Redownload even if file has already been downloaded? Defaults to FALSE.}

\item{dest_dir}{character. Directory in which downloaded files will be stored.
If left unset, will use the \code{statnipokladna.dest_dir} option if the option is set, and \code{tempdir()} otherwise. Will be created if it does not exist.}
}
\value{
A \link[tibble:tibble-package]{tibble} of same length as \code{data}, with added columns from \code{codelist}. See Details.
}
\description{
Joins a provided codelist, or downloads and processes one if necessary, and adds it to the data.
}
\details{
The \code{data} argument should be a data frame produced by \code{sp_get_table()} If this is true, the \code{period_column} argument is not needed.
The \code{codelist} argument, if a data frame, should be a data frame produced by
\code{sp_get_codelist()}. Specifically, it assumes it contains the following columns:
\itemize{
\item start_date, a date
\item end_date, a date
\item column with the code, character usually named the same as the codelist
}

#' You can usually tell which codelist you need from the name of the column whose code you
are looking to expand, e.g. the codes in column paragraf can be expanded by codelist paragraf.

The function filters the codelist to obtain a set of entries relevant to the time period of \code{data}.
If \code{data} contains tables for multiple periods, this is handled appropriately.
Codelist-originating columns in the resulting data frame are renamed so they do not interfere with
joining additional codelists, perhaps in a single pipe call.

Note that some codelists are "secondary" and can only be joined onto other codelists.
If a codelist does not join using \code{sp_add_codelis()}, store the output of \code{sp_get_codelist()} and join
it manually using \code{dplyr}.
}
\examples{
\dontrun{
sp_get_table("budget-central", 2017) \%>\%
  sp_add_codelist("polozka") \%>\%
  sp_add_codelist("paragraf")

pol <- sp_get_codelist("paragraf")
par <- sp_get_codelist("polozka")

sp_get_table("budget-central", 2017) \%>\%
  sp_add_codelist(pol) \%>\%
  sp_add_codelist(par)
}
}
\seealso{
Other Core workflow: 
\code{\link{sp_get_codelist}()},
\code{\link{sp_get_dataset}()},
\code{\link{sp_get_table}()}
}
\concept{Core workflow}
