% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statebins.R
\name{statebins}
\alias{statebins}
\title{Create a new ggplot-based "statebin" chart for USA states/territories}
\usage{
statebins(
  state_data,
  state_col = "state",
  value_col = "value",
  dark_label = "black",
  light_label = "white",
  na_label = "white",
  font_size = 3,
  state_border_col = "white",
  state_border_size = 2,
  round = FALSE,
  radius = grid::unit(6, "pt"),
  ggplot2_scale_function = ggplot2::scale_fill_distiller,
  ...
)
}
\arguments{
\item{state_data}{data frame of states and values to plot}

\item{state_col}{column name in \code{state_data} that has the states. no duplicates
and can be names (e.g. "\code{Maine}") or abbreviatons (e.g. "\code{ME}")}

\item{value_col}{column name in \code{state_data} that holds the values to be plotted}

\item{dark_label, light_label, na_label}{dark/light/NA label colors. The specified color will be used
when the algorithm determines labels should be inverted.}

\item{font_size}{font size (default = \code{3})}

\item{state_border_col}{default "\code{white}" - this creates the "spaces" between boxes}

\item{state_border_size}{border size}

\item{round}{rounded corners (default: \code{FALSE})}

\item{radius}{if \code{round} is \code{TRUE} then use \code{grid::unit} to specify the corner radius.
Default is \code{grid::unit(6, "pt")} if using rounded corners.}

\item{ggplot2_scale_function}{ggplot2 scale function to use. Defaults to \code{scale_fill_distiller}
since you're likely passing in continuous data when you shouldn't be :-)}

\item{...}{additional parameters to the scale function}
}
\value{
ggplot2 object
}
\description{
Pass in a data frame and get back a square choropleth.
}
\details{
The \code{state_col} and \code{value_col} parameters default to \code{state} and \code{value}. That means
if you name the columns you want to plot with those names, you can forego passing them
in. Othersise, use \code{"strings"}.

A \emph{handy} feature of this function is that you can specify a \code{dark_label} color
and a \code{light_label} color. What does that mean? Well, you also pass in the
color scale function you're going to use and \code{statebins} will apply it and use
that information to determine what the tile color is and --- if it's "dark" it will
use the \code{light_label} and if it's "light" it will use the \code{dark_label} color. That
means the labels will never blend in to the background (as long as you specify
decent label colors).

You can customize the scale function you pass in by using name parameters. All named
parameters not used by \code{statebins()} itself get passed to the scale function.
}
\examples{
data(USArrests)

USArrests$state <- rownames(USArrests)
statebins(USArrests, value_col="Assault", name = "Assault") +
  theme_statebins(legend_position="right")
}
