#' Create United States Uniform Cartogram Heatmaps
#'
#' The cartogram heatmaps generated by the included methods
#' are an alternative to choropleth maps for the United States
#' and are based on work by the Washington Post graphics department in their report
#' on "The states most threatened by trade"
#' (<http://www.washingtonpost.com/wp-srv/special/business/states-most-threatened-by-trade/>).
#' "State bins" preserve as much of the geographic placement of the states as
#' possible but have the look and feel of a traditional heatmap. Functions are
#' provided that allow for use of a binned, discrete scale, a continuous scale
#' or manually specified colors depending on what is needed for the underlying data.
#'
#' @md
#' @name statebins-package
#' @docType package
#' @author Bob Rudis (bob@@rud.is)
#' @importFrom grid unit
#' @importFrom scales alpha
#' @importFrom ggplot2 ggplot geom_tile scale_fill_manual guides geom_tile ggplotGrob
#' @importFrom ggplot2 geom_point geom_text scale_color_manual guides theme labs
#' @importFrom ggplot2 scale_x_continuous scale_y_continuous coord_equal theme_bw
#' @importFrom ggplot2 aes element_rect element_blank element_text resolution
#' @importFrom ggplot2 aes_string aes_ scale_y_reverse layer GeomRect margin %+replace%
#' @importFrom ggplot2 scale_fill_brewer ggtitle rel ggproto draw_key_polygon Geom Stat
NULL
