% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complexity_measures_q-log.R
\name{permutation_entropy_qlog}
\alias{permutation_entropy_qlog}
\title{A function to compute q-log permutation entropy}
\usage{
permutation_entropy_qlog(opd, q)
}
\arguments{
\item{opd}{A numeric vector that details an ordinal pattern distribution.}

\item{q}{q-log parameter}
}
\value{
The q-log permutation entropy value.
}
\description{
q-log permutation entropy
}
\details{
This function calculates the q-log permutation entropy as described in Ribeiro et al. 2017.
}
\examples{
x = arima.sim(model=list(ar = 0.3), n = 10^4)
opd = ordinal_pattern_distribution(x = x, ndemb = 6)
permutation_entropy_qlog(opd = opd, q = 1)
}
\references{
Ribeiro et al. 2017, https://arxiv.org/abs/1705.04779.
}
\author{
Sebastian Sippel
}
