% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/igraph_conversion.R
\name{igraph-conversion}
\alias{igraph-conversion}
\alias{get_edges}
\alias{get_edges.sevt}
\alias{get_vertices}
\alias{get_vertices.sevt}
\alias{get_edges.ceg}
\alias{get_vertices.ceg}
\alias{as_igraph}
\alias{as_igraph.sevt}
\alias{as_igraph.ceg}
\title{\pkg{igraph} conversion}
\usage{
get_edges(x, ignore = x$name_unobserved, ...)

\method{get_edges}{sevt}(x, ignore = x$name_unobserved, ...)

get_vertices(x, ignore = x$name_unobserved, ...)

\method{get_vertices}{sevt}(x, ignore = x$name_unobserved, ...)

\method{get_edges}{ceg}(x, ignore = x$name_unobserved, ...)

\method{get_vertices}{ceg}(x, ignore = x$name_unobserved, ...)

as_igraph(x, ignore = x$name_unobserved, ...)

\method{as_igraph}{sevt}(x, ignore = x$name_unobserved, ...)

\method{as_igraph}{ceg}(x, ignore = x$name_unobserved, ...)
}
\arguments{
\item{x}{an object of class \code{\link{sevt}} or \code{\link{ceg}}.}

\item{ignore}{vector of stages which will be ignored and excluded,
by default the name of the unobserved stages stored in
\code{x$name_unobserved}.}

\item{...}{additional parameters.}
}
\value{
for \code{get_edges}: the edges list corresponding
to the graph associated to \code{x}.

for \code{get_vertices}: the vertices list corresponding
to the graph associated to \code{x}.

for \code{as.igraph}: a graph object from the
\pkg{igraph} package.
}
\description{
Obtain the graph representation of a staged tree or a CEG as
an object from the \pkg{igraph} package.
}
\details{
Functions to transalte the graph structure of a \code{\link{sevt}}
or \code{\link{ceg}} object to a graph object from the
\pkg{igraph} package.
Additional functions that extract the edge lists
and the vertices are available.
This can be useful, for example to plot the staged tree  with
\pkg{igraph} or additional packages (see the examples).
}
\examples{
mod <- stages_bhc(full(Titanic))
get_edges(mod)
get_vertices(mod)
\dontrun{
library(igraph)
library(ggraph)
######## sevt example ########
## convert to igraph object
g <- as_igraph(mod)
## plot with igraph directly
plot(g, layout = layout_with_sugiyama)
## plot with ggraph
ggraph(g, "sugiyama") +
  geom_edge_fan(
    aes(
      label = label,
      label_pos = 0.5 + runif(length(label), -0.1, 0.1)
    ),
    angle_calc = "along", show.legend = FALSE, check_overlap = FALSE,
    end_cap = circle(0.02, "npc"),
    arrow = grid::arrow(
      angle = 25,
      length = unit(0.025, "npc"),
      type = "closed"
    )
  ) +
  geom_node_point(aes(x = x, y = y, color = stage),
    size = 5,
    show.legend = FALSE
  ) +
  ggforce::theme_no_axes() + coord_flip() + scale_y_reverse()

######## ceg example ########
g.ceg <- as_igraph(ceg(mod))
### igraph plotting functions can be used
plot(g.ceg, layout = layout.sugiyama)
### igraph object can be also plotted with ggplot2 and ggraph
ggraph(g.ceg, "sugiyama") +
  geom_edge_fan(
    aes(
      label = label,
      color = label,
      label_pos = 0.5 + runif(length(label), -0.1, 0.1)
    ),
    angle_calc = "along", show.legend = FALSE, check_overlap = FALSE,
    end_cap = circle(0.02, "npc"),
    arrow = grid::arrow(
      angle = 25,
      length = unit(0.025, "npc"),
      type = "closed"
    )
  ) +
  geom_node_point(aes(x = x, y = y, color = stage), size = 3, show.legend = FALSE) +
  ggforce::theme_no_axes() + coord_flip() + scale_y_reverse()
}
}
