% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_ss3model.r
\name{run_ss3model}
\alias{run_ss3model}
\title{Run an operating or estimation model for a specified set of scenario IDs}
\usage{
run_ss3model(scenarios, iterations, type = c("om", "em"),
  admb_options = "", hess = FALSE, ignore.stdout = TRUE,
  admb_pause = 0.05, show.output.on.console = FALSE, ...)
}
\arguments{
\item{scenarios}{Which scenarios to run. Controls which folder contains the
model that SS3 should run on.}

\item{iterations}{Which iterations to run. Controls which folder contains
the model that SS3 should run on.}

\item{type}{Are you running the operating or estimation models?}

\item{admb_options}{Any additional options to pass to the SS3 command.}

\item{hess}{Calculate the Hessian on estimation model runs?}

\item{ignore.stdout}{Passed to \code{system}. If \code{TRUE} then ADMB
output is not printed on screen. This will be slightly faster. Set to
\code{FALSE} to help with debugging.}

\item{admb_pause}{A length of time (in seconds) to pause after running the
simulation model. This can be necessary on certain computers where file
writing can be slightly delayed. For example, on computers where the files
are written over a network connection. If the output files haven't
finished writing before \R starts looking for the output then the
simulation will crash with an error about missing files. The default
value is set to \code{0.01} seconds, just to be safe.}

\item{show.output.on.console}{Logical: passed on to
\code{\link[base]{system}}.}

\item{...}{Anything else to pass to \code{\link[base]{system}}.}
}
\description{
This function takes care of calling SS3. Importantly, it parses whether the
user is on Unix or Windows and calls the binary correctly. This lower-level
function is meant to be called by higher level functions such as
\code{\link{run_ss3sim}}, \code{\link{ss3sim_base}}, or your own custom
function.
}
\details{
ss3sim requires you to place the SS executable in your
path. See the vignette \code{vignette("ss3sim-vignette")} for details on
this process. The executables themselves can be downloaded from:
\url{https://www.dropbox.com/sh/zg0sec6j20sfyyz/AACQiuk787qW882U2euVKoPna}
#'
}
\seealso{
\code{\link{ss3sim_base}}, \code{\link{run_ss3sim}}
}
\author{
Sean C. Anderson
}
