#' Set or get a SQUID (to follow)
#'
#' Because the SQUID is saved in the options, it persists when changed
#' e.g. in function calls, for example when using [lapply()].
#'
#' @param x A SQUID (or several; the highest is stored).
#' @param namespace Optionally, for saving multiple SQUIDs, a namespace.
#'
#' @returns Invisibly, x.
#' @export
#' @rdname saving_squids
#'
#' @examples exampleSQUID <-
#'   squids::squids();
#'
#' squids::set_squid(
#'   exampleSQUID
#' );
#'
#' squids::get_squid();
set_squid  <- function(x,
                       namespace = NULL) {
  if (is.null(namespace)) {
    optionName <- "squids_saved_SQUID";
  } else {
    optionName <- paste0("squids_", namespace);
  }
  optionToSet <- list(highest_squid(x));
  names(optionToSet) <- optionName;
  do.call(
    options,
    optionToSet
  );
  return(invisible(x));
}
