testthat::context("ExprBinOp class")

testthat::test_that("Initializer works fine", {
  testthat::expect_error(ExprBinOp$new())
  testthat::expect_error(ExprBinOp$new("a", "=", 10))
  testthat::expect_error(ExprBinOp$new("a", "=", ExprValue$new(10)))
  testthat::expect_error(ExprBinOp$new(ExprValue$new("a"), "=", 10))
  ExprBinOp$new(ExprField$new("a"), "=", ExprValue$new(10))
})

testthat::test_that("Conversion to string works fine", {
  x <- ExprBinOp$new(ExprField$new("a"), "=", ExprValue$new(10))
  testthat::expect_equal(x$toString(), "(a = 10)")

  x <- ExprBinOp$new(ExprField$new("a"), "=", ExprValue$new("10"))
  testthat::expect_equal(x$toString(), "(a = '10')")

  options(sqlq_spaces = FALSE)
  testthat::expect_equal(x$toString(), "(a='10')")
  options(sqlq_spaces = TRUE)

  x <- ExprBinOp$new(ExprField$new("a"), "or", ExprValue$new(10))
  testthat::expect_equal(x$toString(), "(a OR 10)")

  options(sqlq_uppercase = FALSE)
  testthat::expect_equal(x$toString(), "(a or 10)")
  options(sqlq_uppercase = TRUE)
})
