% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/live_connection.R
\name{live_connection}
\alias{live_connection}
\title{Return the named connection or NULL}
\usage{
live_connection(conn_name)
}
\arguments{
\item{conn_name}{Chr. The name of the live connection you want (use
\link{connection_info} to get names of available connections).}
}
\value{
A live connection to a database, or NULL, invisibly, if
\code{conn_name} is not the name of a live connection
}
\description{
Return the named connection or NULL
}
\examples{
library(sqlhelper)
connect(
  system.file("examples/sqlhelper_db_conf.yml",
              package="sqlhelper")
)
connection_info()

conn <- live_connection("simple_sqlite")
conn

DBI::dbDisconnect(conn)
is.null(live_connection("simple_sqlite"))
is.null(live_connection("foo"))

}
