% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spsUtil.R
\name{msg}
\alias{msg}
\alias{spsinfo}
\alias{spswarn}
\alias{spserror}
\title{pretty logging message}
\usage{
msg(
  msg,
  level = "INFO",
  .other_color = NULL,
  info_text = "INFO",
  warning_text = "WARNING",
  error_text = "ERROR",
  use_color = TRUE
)

spsinfo(msg, verbose = NULL)

spswarn(msg)

spserror(msg)
}
\arguments{
\item{msg}{a character string of message or a vector of character strings,
each item in the vector presents one line of words}

\item{level}{typically, one of "INFO", "WARNING", "ERROR", not case sensitive.
Other custom levels will work too.}

\item{.other_color}{hex color code or named colors, when levels are not in
"INFO", "WARNING", "ERROR", this value will be used}

\item{info_text}{info level text prefix, use with "INFO" level}

\item{warning_text}{warning level text prefix, use with "WARNING" level}

\item{error_text}{error level text prefix, use with "ERROR" level}

\item{use_color}{bool, default `TRUE`, to use color if supported?}

\item{verbose}{bool, default get from sps project options, can be overwritten}
}
\value{
see description and details
}
\description{
If

  1. `use_color = TRUE` or
  2. under SPS main package `use_crayon`option is `TRUE`
  3. In a console that supports colors

Then the message will be colorful, other wise no color.

"INFO" level spawns `message`, "WARNING" is `warning`, "ERROR" spawns `stop`,
other levels use `cat`.

`spsinfo`, `spswarn`, `spserror` are higher level wrappers of `msg`. The
only difference is they have `SPS-` prefix.

`spsinfo` has an additional
arg `verbose`. This arg works similarly to all other `verbose` args in
SPS:
1. if not specified, it follows the project option. If SPS option `verbose` is
set to `TRUE`, message will be displayed; if `FALSE`, mute the message.
2. It can be be forced to `TRUE` and `FALSE`. `TRUE` will forcibly generate the msg, and `FALSE`
will mute the message.
}
\details{
1. If `use_color` is `TRUE`, output message will forcibly use color if the console has color
support, ignore SPS `use_crayon` option.
2. If `use_color` is `FALSE`, but you are using within SPS framework, the `use_crayon` option
is set to `TRUE`, color will be used.
3. Otherwise message will be no color.
}
\examples{
msg("this is info")
msg("this is warning", "warning")
try(msg("this is error", "error"))
msg("this is another level", "my level", "green")
spsinfo("some msg, verbose false", verbose = FALSE) # will not show up
spsinfo("some msg, verbose true", verbose = TRUE)
spswarn("sps warning")
try(spserror("sps error"))
}
