% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extras.R
\name{plot_outcome_by_visit_and_group}
\alias{plot_outcome_by_visit_and_group}
\title{Plot Outcome Variable by Timepoint and Study Arm}
\usage{
plot_outcome_by_visit_and_group(
  data,
  outcome_var,
  scheduled_timepoint_var,
  group_var,
  ...,
  geom = ggplot2::geom_boxplot,
  geom_args = list(na.rm = TRUE)
)
}
\arguments{
\item{data}{(\verb{data frame})\cr The data frame that will be supplied to
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}.}

\item{outcome_var}{(\code{numeric})\cr The continuous outcome variable to supply
to the \code{y} argument of \code{\link[ggplot2:aes]{ggplot2::aes()}}. Whatever is supplied will be
\link[rlang:embrace-operator]{quoted and evaluated} \link[rlang:topic-data-mask]{in the context of} \code{data}.}

\item{scheduled_timepoint_var}{(\code{\link{ordered}})\cr The variable containing the
scheduled timepoints to supply to the \code{x} argument of \code{\link[ggplot2:aes]{ggplot2::aes()}}..
Whatever is supplied will be \link[rlang:embrace-operator]{quoted and evaluated} \link[rlang:topic-data-mask]{in the context of} \code{data}.}

\item{group_var}{(\code{numeric})\cr The grouping variable (probably the study
arm) to supply to the \code{fill} argument of \code{\link[ggplot2:aes]{ggplot2::aes()}}.. Whatever is
supplied will be \link[rlang:embrace-operator]{quoted and evaluated} \link[rlang:topic-data-mask]{in the context of} \code{data}.}

\item{...}{Forwarded onto \code{\link[ggplot2:ggplot]{ggplot2::ggplot}}\code{(}\code{\link[ggplot2:aes]{ggplot2::aes}}\verb{)}.}

\item{geom}{(\code{function})\cr The \code{ggplot2} "geom" to use. Defaults to
\code{\link[ggplot2:geom_boxplot]{ggplot2::geom_boxplot()}}.}

\item{geom_args}{(\code{list})\cr A list of arguments to supply to \code{geom}.
Defaults to \code{list(na.rm = TRUE)}.}
}
\value{
A \link[ggplot2:ggplot]{ggplot} object.
}
\description{
\link[ggplot2:ggplot2-package]{Plot} a continuous outcome for each combination of
scheduled visit and study arm.
}
\examples{

# Create a usable data set out of mmrm::fev_data
fev_mod <- mmrm::fev_data
fev_mod$VISITN <- fev_mod$VISITN * 10
fev_mod$time_cont <- fev_mod$VISITN + rnorm(nrow(fev_mod))
fev_mod$obs_visit_index <- round(fev_mod$time_cont)

plot_outcome_by_visit_and_group(
    data = fev_mod,
    outcome_var = FEV1,
    scheduled_timepoint_var = as.ordered(VISITN),
    group_var = ARMCD
)
}
