% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/spinyReg.R
\name{spinyReg}
\alias{spinyReg}
\alias{spinyreg}
\title{spinyReg}
\usage{
spinyreg(X, Y, alpha = 0.1, gamma = 1, z = rep(1, ncol(X)),
  intercept = TRUE, normalize = TRUE, verbose = 1, recovery = TRUE,
  maxit = 1000, eps = 1e-10)
}
\arguments{
\item{X}{matrix of features. Do NOT include intercept.}

\item{Y}{matrix of responses.}

\item{alpha}{numeric scalar; prior value for the alpha parameter
(see the model's details). Default is 0.1.}

\item{gamma}{numeric scalar; prior value for the gamma parameter
(see the model's details). Default is 1.}

\item{z}{numeric vector; prior support of active variable. Default
is \code{rep(1,p)}, meaning all variable activated}

\item{intercept}{logical; indicates if a vector of intercepts
should be included in the model. Default is \code{TRUE}.}

\item{normalize}{logical; indicates if predictor variables should
be normalized to have unit L2 norm before fitting.  Default is
\code{TRUE}.}

\item{verbose}{integer; activate verbose mode from '0' (nothing)
to '2' (detailed output).

should be included in the model. Default is \code{TRUE}.}

\item{recovery}{logical; indicates if the full path of models
should be inspected for model selection. Default is \code{TRUE}.}

\item{maxit}{integer; the maximal number of iteration
(i.e. number of alternated optimization between each parameter)
in the Expectation/Maximization algorithm.}

\item{eps}{a threshold for convergence. Default is \code{1e-10}.}
}
\value{
an object with class \code{spinyreg}, see the
documentation page \code{\linkS4class{spinyreg}} for details.
}
\description{
Computethe path of solution of a spinyReg fit.
}
\examples{
\dontrun{
data <- read.table(file="http://statweb.stanford.edu/~tibs/ElemStatLearn/datasets/prostate.data")
x <- data[, 1:8]
y <- data[, 9]
out <- spinyreg(x,y,verbose=2)
}
}
\seealso{
See also \code{\linkS4class{spinyreg}}.
}
\keyword{models,}
\keyword{regression}

