% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{anomaly_thresh}
\alias{anomaly_thresh}
\title{Apply threshold to anomaly score}
\usage{
anomaly_thresh(x, threshold = 0.99, ...)
}
\arguments{
\item{x}{Numeric vector of anomaly scores (e.g. created by \code{anomaly_score}).}

\item{threshold}{Numeric value to determine the threshold to flag outliers among the score.}

\item{...}{Additional parameters passed to \code{quantile}.}
}
\value{
Logical vector referencing which, if any, of the provided values are outliers.
}
\description{
A helper function that wraps around \code{quantile} to apply a threshold to anomaly scores.
}
\examples{
test_data <- c(1,2,3,4,5,100,5,4,3,2,1)
anomaly_thresh(test_data, 0.99)
}
