.internal_xmapdf_print = \(x,keyname = "libsizes",significant = FALSE){
  resdf = x[[1]]
  bidirectional = x$bidirectional
  if (bidirectional){
    if (significant) {
      resdf = resdf[resdf$x_xmap_y_sig < 0.05 & resdf$y_xmap_x_sig < 0.05,
                    c(keyname, "y_xmap_x_mean", "x_xmap_y_mean"),drop = FALSE]
    } else {
      resdf = resdf[,c(keyname, "y_xmap_x_mean", "x_xmap_y_mean"),drop = FALSE]
    }
    names(resdf) = c(keyname,
                     paste0(x$varname[1], "->", x$varname[2]),
                     paste0(x$varname[2], "->", x$varname[1]))
  } else {
    if (significant) {
      resdf = resdf[resdf$y_xmap_x_sig < 0.05,c(keyname, "y_xmap_x_mean"),drop = FALSE]
    } else {
      resdf = resdf[,c(keyname, "y_xmap_x_mean"),drop = FALSE]
    }
    names(resdf) = c(keyname,
                     paste0(x$varname[1], "->", x$varname[2]))
  }
  return(resdf)
}

#' @export
#' @noRd
print.ccm_res = \(x,significant = FALSE,...){
  print(.internal_xmapdf_print(x,significant = significant))
}

#' @export
#' @noRd
print.cmc_res = \(x,significant = FALSE,...){
  print(.internal_xmapdf_print(x,"neighbors",significant = significant))
}

#' @export
#' @noRd
print.pcm_res = \(x,significant = FALSE,...){
  pxmap = x[-2]
  xmap = x[-1]

  cat('-------------------------------------- \n')
  cat("***partial cross mapping prediction*** \n")
  cat('-------------------------------------- \n')
  print(.internal_xmapdf_print(pxmap,significant = significant))
  cat("\n------------------------------ \n")
  cat("***cross mapping prediction*** \n")
  cat('------------------------------ \n')
  print(.internal_xmapdf_print(xmap,significant = significant))
}

#' @export
#' @noRd
print.pc_res = \(x,...){
  pc = x$summary
  if (x$bidirectional){
    pc$direction = rep(c(paste0(x$varname[1], " -> ", x$varname[2]),
                         paste0(x$varname[2], " -> ", x$varname[1])), each = 3)
  } else {
    pc$direction = paste0(x$varname[1], " -> ", x$varname[2])
  }
  print(pc)
}

#' @export
#' @noRd
print.rpc_res = \(x,...){
  pc = x$xmap
  if (x$bidirectional){
    pc$direction = rep(c(paste0(x$varname[1], " -> ", x$varname[2]),
                         paste0(x$varname[2], " -> ", x$varname[1])),
                       each = (nrow(pc) / 2))
  } else {
    pc$direction = paste0(x$varname[1], " -> ", x$varname[2])
  }
  names(pc)[5] = "strength"
  print(pc[,c(1,2,5,7),drop = FALSE])
}

#' @export
#' @noRd
print.xmap_self = \(x,...){
  res = as.matrix(x$xmap)
  if (x$method == "smap") {
    cat(paste0("The suggested theta for variable ", x$varname, " is ", OptThetaParm(res)), "\n")
  } else {
      if (x$method == "simplex") {
        res = OptSimplexParm(res)
      } else if (x$method == "ic") {
        res = OptICparm(res)
      } else if (x$method == "pc") {
        res = OptPCparm(res,x$maximize)
      }
      cat(paste0("The suggested E,k,tau for variable ", x$varname, " is ", res[1], ", ", res[2], " and ", res[3]), "\n")
      if (res[1] == 1 && res[3] == 0) warning("When tau = 0, E should not be 1")
  }
}

#' @export
#' @noRd
print.sc_res = \(x,...){
  sc = round(x$sc,3)
  cat(c("spatial causality test",
        paste0(paste0(x$varname[1], " -> ", x$varname[2],": statistic = "), sc[1], ", p value = ", sc[2]),
        paste0(paste0(x$varname[2], " -> ", x$varname[1],": statistic = "), sc[3], ", p value = ", sc[4])),
      sep = "\n")
}

#' @export
#' @noRd
plot.ccm_res = \(x, family = "serif",
                 legend_sig = TRUE, legend_texts = NULL,
                 legend_cols = c("#ed795b","#608dbe"),
                 draw_ci = FALSE, ci_alpha = 0.25,
                 xbreaks = NULL, xlimits = NULL,
                 ybreaks = seq(0, 1, by = 0.1),
                 ylimits = c(-0.05, 1),
                 ylabel = expression(rho), ...){
  resdf = x[[1]]
  bidirectional = x$bidirectional

  if(is.null(xbreaks)) xbreaks = resdf$libsizes
  if(is.null(xlimits)) xlimits = c(min(xbreaks)-1,max(xbreaks)+1)
  if (is.null(legend_texts)){
    legend_texts = c(paste0(x$varname[2], " xmap ", x$varname[1]),
                     paste0(x$varname[1], " xmap ", x$varname[2]))
    if (legend_sig){
      pval = resdf |>
        dplyr::slice_tail(n = 1) |>
        dplyr::select(y_xmap_x_sig,x_xmap_y_sig) |>
        unlist() |>
        round(3)
      legend_texts = paste0(legend_texts,", P = ",pval)
    }
  }
  legend_texts = .check_inputelementnum(legend_texts,2)
  legend_cols = .check_inputelementnum(legend_cols,2)
  names(legend_cols) = c("x - y","y - x")

  ci_alpha = .check_inputelementnum(ci_alpha,2)

  fig1 = ggplot2::ggplot(data = resdf,
                         ggplot2::aes(x = libsizes)) +
    ggplot2::geom_line(ggplot2::aes(y = y_xmap_x_mean,
                                    color = "x - y"),
                       lwd = 1.25)

  if (draw_ci) {
    fig1 = fig1 +
      ggplot2::geom_ribbon(ggplot2::aes(ymin = y_xmap_x_lower,
                                        ymax = y_xmap_x_upper),
                           alpha = ci_alpha[1], fill = legend_cols[1])
  }

  if (bidirectional){
    fig1 = fig1 + ggplot2::geom_line(ggplot2::aes(y = x_xmap_y_mean,
                                                  color = "y - x"),
                                     lwd = 1.25)

    if (draw_ci) {
      fig1 = fig1 +
        ggplot2::geom_ribbon(ggplot2::aes(ymin = x_xmap_y_lower,
                                          ymax = x_xmap_y_upper),
                             alpha = ci_alpha[2], fill = legend_cols[2])
    }
  }

  fig1 = fig1 +
    ggplot2::scale_x_continuous(breaks = xbreaks, limits = xlimits,
                                expand = c(0, 0), name = "Library Size") +
    ggplot2::scale_y_continuous(breaks = ybreaks, limits = ylimits,
                                expand = c(0, 0), name = ylabel) +
    ggplot2::scale_color_manual(values = legend_cols,
                                labels = legend_texts,
                                name = "") +
    ggplot2::theme_bw(base_family = family) +
    ggplot2::theme(axis.text.x = ggplot2::element_text(angle = 30),
                   panel.grid = ggplot2::element_blank(),
                   legend.position = "inside",
                   legend.justification = c(0.05,1),
                   legend.background = ggplot2::element_rect(fill = 'transparent'))
  return(fig1)
}

#' @export
#' @noRd
plot.cmc_res = \(x, ...){
  xmap = x[-1]
  class(xmap) = "ccm"
  fig1 = plot.ccm_res(xmap,legend_sig = FALSE,draw_ci = FALSE,
                      ylabel = "Causal Score",...)
  return(fig1)
}


#' @export
#' @noRd
plot.pcm_res = \(x, partial = TRUE, ...){
  indice = ifelse(partial,-2,-1)
  xmap = x[indice]
  class(xmap) = "ccm"
  fig1 = plot.ccm_res(xmap,...)
  return(fig1)
}

#' @export
#' @noRd
plot.rpc_res = \(x, family = "serif",
                 xbreaks = NULL, xlimits = NULL,
                 ybreaks = seq(0, 1, by = 0.1),
                 ylimits = c(-0.05, 1), ...){
  xmapdf = x$xmap
  if("q50" %in% names(xmapdf)) xmapdf = dplyr::rename(xmapdf,causality = q50)
  if (x$bidirectional){
    xmapdf$direction = rep(c(paste0(x$varname[1], " %->% ", x$varname[2]),
                             paste0(x$varname[2], " %->% ", x$varname[1])),
                             each = (nrow(xmapdf) / 2))
  } else {
    xmapdf$direction = paste0(x$varname[1], " %->% ", x$varname[2])
  }
  if(is.null(xbreaks)) xbreaks = xmapdf$libsizes
  if(is.null(xlimits)) xlimits = c(min(xbreaks)-1,max(xbreaks)+1)

  ggplot2::ggplot(xmapdf, ggplot2::aes(x = libsizes, y = causality, color = type)) +
    ggplot2::geom_line(linewidth = 1.25) +
    ggplot2::facet_wrap(~ direction, scales = "fixed", ncol = 2,
                        labeller = ggplot2::label_parsed) +
    ggplot2::scale_color_manual(name = NULL,
                                values = c("dark" = "#6A0DAD", "negative" = "#FF4136", "positive" = "#0074D9")) +
    ggplot2::scale_x_continuous(breaks = xbreaks, limits = xlimits,
                                expand = c(0, 0), name = "Library Size") +
    ggplot2::scale_y_continuous(breaks = ybreaks, limits = ylimits,
                                expand = c(0, 0), name = "Causal Strength") +
    ggplot2::theme_bw(base_family = family) +
    ggplot2::theme(
      legend.position = "bottom",
      legend.box = "horizontal",
      panel.grid.minor = ggplot2::element_blank(),
      axis.text.x = ggplot2::element_text(angle = 30),
      strip.text = ggplot2::element_text(face = "bold")
    )
}
