% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Wave-methods.R
\docType{methods}
\name{concat}
\alias{concat}
\alias{concat,Wave-method}
\alias{concat,WaveMC-method}
\alias{concat,TaggedWave-method}
\alias{concat,TaggedWaveMC-method}
\title{Concatenate two or more Wave-like objects.}
\usage{
concat(object, ..., method = "bind")

\S4method{concat}{Wave}(object, ..., method = "bind")

\S4method{concat}{WaveMC}(object, ..., method = "bind")

\S4method{concat}{TaggedWave}(object, ..., method = "bind")

\S4method{concat}{TaggedWaveMC}(object, ..., method = "bind")
}
\arguments{
\item{object}{A Wave like object.}

\item{...}{Wave like objects to concatenate to object.}

\item{method}{One of "bind", "noClick". Default is "bind".}
}
\value{
A concatenated Wave like object, with type of \code{object}.
}
\description{
The \code{concat()} method is a more flexible version of the \code{bind()} method
from \code{tuneR} package, that allows specifying more advanced types of
concatenation. Setting \code{method} to "noClick" will remove any click between
Wave objects caused by sudden jumps in amplitude by applying \code{tuneR::prepComb()}
appropriately with default value of zero (this is only effective for the left
channel or stereo or multi-channel recordings).
}
