% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sonar.R
\name{SpeedOfSoundSeaWaterWilson}
\alias{SpeedOfSoundSeaWaterWilson}
\title{Calculation of speed of sound in sea water from Wilson 1960}
\source{
N. N. Andreyev Acoustics Institute, 2015
The speed of sound in sea water
\url{http://www.akin.ru/spravka_eng/s_i_svel_e.htm}
}
\usage{
SpeedOfSoundSeaWaterWilson(temperatureC, S, P)
}
\arguments{
\item{temperatureC,}{temperature from -4C to 30C}

\item{S,}{salinity from 0 to 37 per 1000}

\item{P,}{hydrostatic pressure from 0.1 MPa to 100 MPa}
}
\value{
the speed of sound
}
\description{
Returns the speed of sound in sea water from Wilson 1960
}
\examples{
SpeedOfSoundSeaWaterWilson(0, 30, 0.1)
}
\author{
Jose Gama
}
\references{
Wilson W D, 1960
Equation for the speed of sound in sea water
J. Acoust. Soc. Amer., vol.32, N 10, p. 1357
}

