% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/som.nn.accuracy.R
\name{som.nn.confusion}
\alias{som.nn.confusion}
\title{Calculate confusion matrix}
\usage{
som.nn.confusion(x, class.labels)
}
\arguments{
\item{x}{\code{data.frame} with the predictions as returned by the
SOM.nn predict method.}

\item{class.labels}{\code{vector} of correct class labels for the predictions.}
}
\value{
\code{data.frame} containing the confusion matrix.
}
\description{
Calculates the confusion matrix for a prediction result
if the corresponding vector of true class labels
is provided.
}
\details{
The confusion matrix (also called table of confusion) displays the number
of predicted class labels for each actual class. Example:

\tabular{rrrrr}{
\tab pred. cat \tab pred. dog  \tab pred. rabbit \tab unknown \cr
actual cat     \tab   5       \tab   3        \tab   0          \tab  0      \cr
actual dog     \tab   2       \tab   3        \tab   1          \tab  0      \cr
actual rabbit  \tab   0       \tab   2        \tab   9          \tab  2
}

The confusion matrix includes a column \code{unknown} displaying the samples
for which no unambiguous prediction is possible.
}
