% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/som.nn.util.R
\name{norm.softmax}
\alias{norm.softmax}
\title{Softmax normalisation}
\usage{
norm.softmax(x, t = 0.2)
}
\arguments{
\item{x}{vector of votes for classes}

\item{t}{temperature parameter.}
}
\value{
Vector of softmax normalised values.
}
\description{
Calculates a softmax-like normalisation for the class frequencies.
}
\details{
Softmax function is applied to a vector to squeeze the values in a way that they sum up
to 1.0:

\code{som.nn.softmax(x) = exp(x/T) / sum(exp(x/T))}

Low values for \code{T} result in a
strong separation of output values. High values for \code{T}
make output values more equal.
}
