% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CNsim.R
\name{CNsim}
\alias{CNsim}
\title{A function to simulate the dynamics over time wrapping getPARAMS and foodwebode}
\usage{
CNsim(
  usin,
  DIETLIMTS = NA,
  diet_correct = TRUE,
  Conly = FALSE,
  userdefinedinputs = NA,
  start_mod = NA,
  TIMES = 1:100,
  keepallnitrogen = TRUE,
  has_inorganic_nitrogen = FALSE,
  densitydependence = NA,
  inorganic_nitrogen_properties = list(INN = NA, q = NA, eqmN = NA),
  DETEXPT = NA,
  DETEXPTSTART = NA,
  rtn_only_state = TRUE
)
}
\arguments{
\item{usin}{The community you want to simulate.}

\item{DIETLIMTS}{The diet limits matrix for the stoichiometry correction (proportion of diet)?}

\item{diet_correct}{Boolean: Does the organism correct it's diet?}

\item{Conly}{Boolean: Is the model meant for carbon only?}

\item{userdefinedinputs}{Do you want to input a user defined vector of input functions? If NA the input values that keep the system at equilibrium are calculated. If not, put in a vector of input rates for each node.}

\item{start_mod}{A vector of modifications to the starting conditions, which default to the biomass vector in the community. This vector is multiplied by the biomass vector.}

\item{TIMES}{The vector of times that you want to run the model. Defaults to 1 to 100 by 1.}

\item{keepallnitrogen}{Boolean: Keep all the nitrogen pools in the model output? Will be set to FALSE if you are running a stability analysis using the function stability2().}

\item{has_inorganic_nitrogen}{Boolean: Is there an inorganic nitrogen pool?}

\item{densitydependence}{Which nodes have density dependence? NA default means none of them do. Should be a vector of 0 (no DD) and 1 (DD) for each node.}

\item{inorganic_nitrogen_properties}{A list of state variables for the inorganic nitrogen pool (INN = inputs, q = per capita loss of N, eqmN = equilibrium N). Must include a value for two of the three variables and has the final one as NA.}

\item{DETEXPT}{The pool that should be used for the detritus experiment by name or position in the vector usin$prop$ID.}

\item{DETEXPTSTART}{The start of the detritus experiment. Defaults to 100.}

\item{rtn_only_state}{Boolean: Do you want to only return the model state variables? If FALSE then the consumption rates and production efficiency at each time step are also returned.}
}
\value{
The output of the simulation.
}
\description{
A function to simulate the dynamics over time wrapping getPARAMS and foodwebode
}
\details{
A function that simulates the food web over the user defined times. If you do not modify the starting state using start_mod or add a detritus experiment using DETEXPT, then the result will just be a flat line if the food web is stable.
}
\examples{
# Basic example with a 5\% reduction in predator biomass:
CNsim(intro_comm, start_mod = c(0.95, 1,1,1,1,1,1))

# Simulate a decomposition experiment:
CNsim(intro_comm, DETEXPT = c("Detritus1"), DETEXPTSTART = 100)

}
\seealso{
The function uses \code{\link{getPARAMS}} and \code{\link{foodwebode}} to simulate the community.
}
