% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc_update.r
\name{doc_update}
\alias{doc_update}
\title{Update a document.}
\usage{
doc_update(cushion, dbname, doc, docid, rev, as = "list", ...)
}
\arguments{
\item{cushion}{A \code{\link{Cushion}} object. Required.}

\item{dbname}{(character) Database name. Required.}

\item{doc}{(character) Document content. Required.}

\item{docid}{(character) Document ID. Required.}

\item{rev}{(character) Revision id. Required.}

\item{as}{(character) One of list (default) or json}

\item{...}{Curl args passed on to \code{\link[crul]{HttpClient}}}
}
\value{
JSON as a character string or a list (determined by the
\code{as} parameter)
}
\description{
Update a document.
}
\details{
Internally, this function adds in the docid and revision id,
required to do a document update
}
\examples{
\dontrun{
user <- Sys.getenv("COUCHDB_TEST_USER")
pwd <- Sys.getenv("COUCHDB_TEST_PWD")
(x <- Cushion$new(user=user, pwd=pwd))

if ("sofadb" \%in\% db_list(x)) {
  invisible(db_delete(x, dbname="sofadb"))
}
db_create(x, dbname='sofadb')

doc1 <- '{"name":"drink","beer":"IPA"}'
doc_create(x, dbname="sofadb", doc=doc1, docid="b_beer")
doc_get(x, dbname = "sofadb", docid = "b_beer")
revs <- db_revisions(x, dbname = "sofadb", docid = "b_beer")
doc2 <- '{"name":"drink","beer":"IPA","note":"yummy","note2":"yay"}'
doc_update(x, dbname="sofadb", doc=doc2, docid="b_beer", rev=revs[1])
db_revisions(x, dbname = "sofadb", docid = "b_beer")
}
}
