% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db_bulk_get.R
\name{db_bulk_get}
\alias{db_bulk_get}
\title{Query many documents at once}
\usage{
db_bulk_get(cushion, dbname, docid_rev, as = "list", ...)
}
\arguments{
\item{cushion}{A \code{\link{Cushion}} object. Required.}

\item{dbname}{(character) Database name. Required.}

\item{docid_rev}{A list of named lists, each of which must have the
slot \code{id}, and optionally \code{rev} for the revision of the document id}

\item{as}{(character) One of list (default) or json}

\item{...}{Curl args passed on to \code{\link[crul]{HttpClient}}}
}
\value{
Either a list or json (depending on \code{as} parameter)
}
\description{
Query many documents at once
}
\examples{
\dontrun{
# initialize a CouchDB connection
user <- Sys.getenv("COUCHDB_TEST_USER")
pwd <- Sys.getenv("COUCHDB_TEST_PWD")
(x <- Cushion$new(user=user, pwd=pwd))

if ("bulkgettest" \%in\% db_list(x)) {
  invisible(db_delete(x, dbname="bulkgettest"))
}
db_create(x, dbname="bulkgettest")
db_bulk_create(x, "bulkgettest", mtcars)
res <- db_query(x, dbname = "bulkgettest", selector = list(cyl = 8))

# with ids only
ids <- vapply(res$docs, "[[", "", "_id")
ids_only <- lapply(ids[1:5], function(w) list(id = w))
db_bulk_get(x, "bulkgettest", docid_rev = ids_only)

# with ids and revs
ids_rev <- lapply(res$docs[1:3],
  function(w) list(id = w$`_id`, rev = w$`_rev`))
db_bulk_get(x, "bulkgettest", docid_rev = ids_rev)
}
}
