% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/H.inv.select.R
\name{H.inv.select}
\alias{H.inv.select}
\title{Bandwidth matrix selection}
\usage{
H.inv.select(X, H.mult = 1)
}
\arguments{
\item{X}{Matrix of inputs}

\item{H.mult}{Scaling factor for rule-of-thumb smoothing matrix}
}
\value{
Returns inverse bandwidth matrix
}
\description{
Computes inverse of bandwidth matrix using rule-of-thumb from Silverman (1986).
}
\details{
This method performs selection of (inverse) multivariate bandwidth matrices using
Silverman's (1986) rule-of-thumb. Specifically, Silverman recommends setting the bandwidth
matrix to

\deqn{H_{jj}^{1/2} = \left(\frac{4}{M + 2}\right)^{1 / (M + 4)}\times N^{-1 / (M + 4)}\times \mbox{sd}(x^j) \mbox{\ \ \ \ for }j=1,...,M}
\deqn{H_{ab} = 0\mbox{\ \ \ \ for }a\neq b}

where \eqn{M} is the number of inputs, \eqn{N} is the number of observations, and
\eqn{\mbox{sd}(x^j)} is the sample standard deviation of input \eqn{j}.
}
\examples{
data(USMacro)

USMacro <- USMacro[complete.cases(USMacro),]

#Extract data
X <- as.matrix(USMacro[,c("K", "L")])

#Generate bandwidth matrix
print(H.inv.select(X))
#              [,1]         [,2]
# [1,] 3.642704e-08 0.000000e+00
# [2,] 0.000000e+00 1.215789e-08

}
\references{
\insertRef{Silverman}{snfa}
}
