% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tensor_class.R
\docType{methods}
\name{Ops-methods}
\alias{Ops-methods}
\alias{Ops,Tensor,Tensor-method}
\alias{Ops,Tensor,array-method}
\alias{Ops,Tensor,numeric-method}
\alias{Ops,array,Tensor-method}
\alias{Ops,numeric,Tensor-method}
\title{Conformable elementwise operators for Tensor}
\usage{
\S4method{Ops}{Tensor,Tensor}(e1, e2)
}
\arguments{
\item{e1}{left-hand object}

\item{e2}{right-hand object}
}
\description{
Conformable elementwise operators for Tensor
}
\examples{
tnsr <- rand_tensor(c(3,4,5))
tnsr2 <- rand_tensor(c(3,4,5))
tnsrsum <- tnsr + tnsr2
tnsrdiff <- tnsr - tnsr2
tnsrelemprod <- tnsr * tnsr2
tnsrelemquot <- tnsr / tnsr2
for (i in 1:3L){
for (j in 1:4L){
	for (k in 1:5L){
		stopifnot(tnsrsum@data[i,j,k]==tnsr@data[i,j,k]+tnsr2@data[i,j,k])
		stopifnot(tnsrdiff@data[i,j,k]==(tnsr@data[i,j,k]-tnsr2@data[i,j,k]))
		stopifnot(tnsrelemprod@data[i,j,k]==tnsr@data[i,j,k]*tnsr2@data[i,j,k])
		stopifnot(tnsrelemquot@data[i,j,k]==tnsr@data[i,j,k]/tnsr2@data[i,j,k])
}
}
}
}
