% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allgenerics.R
\name{get.P}
\alias{get.P}
\title{Method to compute the value of \eqn{P}}
\usage{
get.P(x, k, states = x$states, var = FALSE, klim = 10000)
}
\arguments{
\item{x}{An object of S3 class \code{smmfit} or \code{smm}.}

\item{k}{A positive integer giving the time horizon.}

\item{states}{Vector giving the states for which the mean sojourn time
should be computed. \code{states} is a subset of \eqn{E}.}

\item{var}{Logical. If \code{TRUE} the asymptotic variance is computed.}

\item{klim}{Optional. The time horizon used to approximate the series in the
computation of the mean sojourn times vector \eqn{m} (cf.
\link{meanSojournTimes} function) for the asymptotic
variance.}
}
\value{
An array giving the value of \eqn{P_{i,j}(k)} at each time between 0
and \code{k} if \code{var = FALSE}. If \code{var = TRUE}, a list containing the
following components:
\describe{
\item{x: }{an array giving the value of \eqn{P_{ij}(k)} at each time
between 0 and \code{k};}
\item{sigma2: }{an array giving the asymptotic variance of the estimator
\eqn{\sigma_{P}^{2}(i, j, k)}.}
}
}
\description{
Method to compute the value of \eqn{P}
(See equation (3.33) p.59).
}
