% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smerc_cluster-summary.R
\name{summary.smerc_cluster}
\alias{summary.smerc_cluster}
\title{Summary of \code{smerc_cluster} object}
\usage{
\method{summary}{smerc_cluster}(object, ..., idx = seq_along(object$clusters), digits = 1)
}
\arguments{
\item{object}{An object of class \code{smerc_cluster}.}

\item{...}{Additional arguments affecting the summary produced.}

\item{idx}{An index vector indicating the elements of
\code{object$clusters} to print information for. The default
is all clusters.}

\item{digits}{Integer indicating the number of decimal places.}
}
\value{
A \code{data.frame} with columns:
\item{nregions}{The number of regions in the cluster.}
\item{max_dist}{The maximum intercentroid distance between all the regions
in the cluster.}
\item{cases}{The number of cases in the cluster.}
\item{ex}{The expected number of cases in the cluster.}
\item{rr}{Relative risk in the cluster window. This is
\code{(cases/pop)/((total_cases - cases)/
(total_population - population))}.}
\item{stat}{The test statistic for the cluster.}
\item{p}{The p-value of the test statistic associated with the cluster.}
}
\description{
Summary of object of class \code{smerc_cluster}.
}
\examples{
data(nydf)
coords <- with(nydf, cbind(x, y))
out <- scan.test(
  coords = coords, cases = floor(nydf$cases),
  pop = nydf$pop, nsim = 49,
  longlat = TRUE, alpha = 0.2
)
# summarize all clusters
summary(out)
# summarize clusters 1 and 3
summary(out, idx = c(1, 3))
}
