% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{cross}
\alias{cross}
\title{Genetics of root growth}
\format{
A data frame with 4 variables: \code{Seed}, \code{Female}, \code{Male}, \code{Root}.
\describe{
  \item{Seed}{Factor. Unique identifier for each individual seed/planted observation.}
  \item{Female}{Factor. Code for the female parent in the cross (levels: "F1" to "F5").}
  \item{Male}{Factor. Code for the male parent in the cross (levels: "M1", "M2").}
  \item{Root}{Integer. Maximum root length (in millimeters) measured for each seedling three weeks after planting.}
}
}
\source{
Welham, S. J., Gezan, S. A., Clark, S. J., and Mead, A. (2015) \emph{Statistical Methods in Biology: Design and analysis of experiments and regression}
}
\usage{
cross
}
\description{
This experiment aimed to investigate the genetic basis of root growth in manipulated lines by crossing two male parents (Male: M1, M2) with five female parents (Female: F1–F5), resulting in ten cross combinations. Up to eight seeds per cross were to be grown in a completely randomized design, and the maximum root length (in mm) was measured for each plant three weeks after sowing (Root). However, due to genetic incompatibilities affecting seed viability, several treatment combinations failed to produce the intended number of replicates, resulting in a total of only 30 observations. The dataset enables analysis of genetic effects on root growth while accounting for variable replication.
}
\keyword{datasets}
