% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01-sample_size.R
\name{get_n_cases}
\alias{get_n_cases}
\title{Calculate estimated number of cases for a condition affecting children under
5 years old in a specified survey area}
\usage{
get_n_cases(N, u5, p)
}
\arguments{
\item{N}{Population for all ages in the specified survey area.}

\item{u5}{Proportion (value from 0 to 1) of population that are aged 6-59
months.}

\item{p}{Prevalence (value from 0 to 1) of condition that is to be assessed.}
}
\value{
A numeric value of the estimated number of cases in the specified
survey area
}
\description{
Calculate estimated number of cases for a condition affecting children under
5 years old in a specified survey area
}
\examples{
## Calculate number of SAM cases in a population of 100000 persons of all
## ages with an under-5 population of 17\% and a prevalence of 2\%
get_n_cases(N = 100000, u5 = 0.17, p = 0.02)

}
