% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{read_ibis}
\alias{read_ibis}
\title{Read IBIS coef output file}
\usage{
read_ibis(file)
}
\arguments{
\item{file}{Input file path}
}
\value{
A tibble containing the 6 columns from the ibis file.
}
\description{
Reads in an \code{ibis} \href{https://github.com/williamslab/ibis}{results file}. Input \code{file} must have six columns, whitespace delimited:
\enumerate{
\item id1 (member 1)
\item id2 (member 2)
\item Kinship Coefficient
\item IBD2 (ratio of IBD2/All SNPS)
\item Segment count
\item Kinship Degree
}
}
\examples{
ibisFile <- system.file("extdata", "3gens.ibis.coef", package="skater", mustWork=TRUE)
ibis <- read_ibis(ibisFile)
ibis

}
