% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confusion_matrix.R
\name{confusion_matrix}
\alias{confusion_matrix}
\title{Calculate various statistics from a confusion matrix}
\usage{
confusion_matrix(
  prediction,
  target,
  positive = NULL,
  prevalence = NULL,
  dnn = c("Predicted", "Target"),
  longer = FALSE,
  ...
)
}
\arguments{
\item{prediction}{A vector of predictions}

\item{target}{A vector of target values}

\item{positive}{The positive class for a 2-class setting. Default is
\code{NULL}, which will result in using the first level of \code{target}.}

\item{prevalence}{Prevalence rate.  Default is \code{NULL}.}

\item{dnn}{The row and column headers for the contingency table returned.
Default is 'Predicted' for rows and 'Target' for columns.}

\item{longer}{Transpose the output to long form.  Default is FALSE (requires
\code{tidyr 1.0}).}

\item{...}{Other parameters, not currently used.}
}
\value{
A list of tibble(s) with the associated statistics and possibly the
frequency table as list column of the first element. If classes contain >1
numeric class and a single non-numeric class (e.g., "1", "2", "3", and
"Unrelated", the RMSE of the reciprocal of the Targets + 0.5 will also be
returned.)
}
\description{
Given a vector of predictions and target values, calculate
numerous statistics of interest. Modified from
\href{https://github.com/m-clark/confusionMatrix}{m-clark/confusion_matrix}.
}
\details{
This returns accuracy, agreement, and other statistics. See the
functions below to find out more. Originally inspired by the
\code{confusionMatrix} function from the \code{caret} package.
}
\examples{
prediction = c(0,1,1,0,0,1,0,1,1,1)
target     = c(0,1,1,1,0,1,0,1,0,1)
confusion_matrix(prediction, target, positive = '1')

set.seed(42)
prediction = sample(letters[1:4], 250, replace = TRUE, prob = 1:4)
target     = sample(letters[1:4], 250, replace = TRUE, prob = 1:4)
confusion_matrix(prediction, target)

prediction = c(rep(1, 50), rep(2, 40), rep(3, 60))
target     = c(rep(1, 50), rep(2, 50), rep(3, 50))
confusion_matrix(prediction, target)
confusion_matrix(prediction, target) \%>\% purrr::pluck("Table")
confusion_matrix(prediction, target, longer=TRUE)
confusion_matrix(prediction, target, longer=TRUE) \%>\%
  purrr::pluck("Other") \%>\%
  tidyr::spread(Class, Value)

# Prediction with an unrelated class
prediction = c(rep(1, 50), rep(2, 40), rep(3, 60), rep("Unrelated", 55))
target     = c(rep(1, 50), rep(2, 50), rep(3, 55), rep("Unrelated", 50))
confusion_matrix(prediction, target)
# Prediction with two unrelated classes
prediction = c(rep(1, 50), rep(2, 40), rep("Third", 60), rep("Unrelated", 55))
target     = c(rep(1, 50), rep(2, 50), rep("Third", 55), rep("Unrelated", 50))
confusion_matrix(prediction, target)

}
\references{
Kuhn, M., & Johnson, K. (2013). Applied predictive modeling.
}
\seealso{
\code{\link{calc_accuracy}} \code{\link{calc_stats}}
}
