% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confusion_matrix.R
\name{calc_stats}
\alias{calc_stats}
\title{Calculate various statistics from a confusion matrix}
\usage{
calc_stats(tabble, prevalence = NULL, positive, ...)
}
\arguments{
\item{tabble}{A frequency table created with \code{\link{table}}}

\item{prevalence}{Prevalence value. Default is \code{NULL}}

\item{positive}{Positive class}

\item{...}{Other, not currently used}
}
\value{
A tibble with (at present) columns for sensitivity, specificity, PPV, NPV, F1 score, detection rate, detection prevalence, balanced accuracy, FDR, FOR, FPR, FNR.  For
more than 2 classes, these statistics are provided for each class.
}
\description{
Given a frequency table of predictions versus target values,
calculate numerous statistics of interest.
}
\details{
Used within confusion_matrix to calculate various confusion matrix
metrics. This is called by \code{confusion_matrix}, but if this is all you
want you can simply supply the table.

Suppose a 2x2 table with notation

\tabular{rcc}{ \tab target \tab \cr Predicted \tab Event \tab No Event
\cr Event \tab A \tab B \cr No Event \tab C \tab D \cr }

The formulas used here are:
\deqn{Sensitivity = A/(A+C)}
\deqn{Specificity = D/(B+D)}
\deqn{Prevalence = (A+C)/(A+B+C+D)}
\deqn{Positive Predictive Value = (sensitivity * prevalence)/((sensitivity*prevalence) + ((1-specificity)*(1-prevalence)))}
\deqn{Negative Predictive Value = (specificity * (1-prevalence))/(((1-sensitivity)*prevalence) + ((specificity)*(1-prevalence)))} \deqn{Detection Rate = A/(A+B+C+D)}
\deqn{Detection Prevalence = (A+B)/(A+B+C+D)}
\deqn{Balanced Accuracy = (sensitivity+specificity)/2}
\deqn{Precision = A/(A+B)}
\deqn{Recall = A/(A+C)}
\deqn{F1 = harmonic mean of precision and recall = (1+beta^2)*precision*recall/((beta^2 * precision)+recall)}
where \code{beta = 1} for this function.
\deqn{False Discovery Rate = 1 - Positive Predictive Value}
\deqn{False Omission Rate = 1 - Negative Predictive Value}
\deqn{False Positive Rate = 1 - Specificity}
\deqn{False Negative Rate = 1 - Sensitivity}
\deqn{D' = qnorm(Sensitivity) - qnorm(1 - Specificity)}
\deqn{AUC ~= pnorm(D'/sqrt(2))}

See the references for discussions of the first five formulas.
Abbreviations:
\describe{
\item{Positive Predictive Value: PPV}{}
\item{Negative Predictive Value: NPV}{}
\item{False Discovery Rate: FDR}{}
\item{False Omission Rate: FOR}{}
\item{False Positive Rate: FPR}{}
\item{False Negative Rate: FNR}{}
}
}
\note{
Different names are used for the same statistics.
\describe{
\item{Sensitivity: True Positive Rate, Recall, Hit Rate, Power}{}
\item{Specificity: True Negative Rate}{}
\item{Positive Predictive Value: Precision}{}
\item{False Negative Rate: Miss Rate, Type II error rate, beta}{}
\item{False Positive Rate: Fallout, Type I error rate, alpha}{}
}

This function is called by \code{confusion_matrix}, but if this is all you
want, you can simply supply the table to this function.
}
\references{
Kuhn, M. (2008), "Building predictive models in R using the
caret package, " \emph{Journal of Statistical Software},
(\url{https://www.jstatsoft.org/article/view/v028i05}).

Altman, D.G., Bland, J.M. (1994) "Diagnostic tests 1: sensitivity and
specificity", \emph{British Medical Journal}, vol 308, 1552.

Altman, D.G., Bland, J.M. (1994) "Diagnostic tests 2: predictive values,"
\emph{British Medical Journal}, vol 309, 102.

Velez, D.R., et. al. (2008) "A balanced accuracy function for epistasis
modeling in imbalanced datasets using multifactor dimensionality
reduction.," \emph{Genetic Epidemiology}, vol 4, 306.
}
\author{
Michael Clark (see \href{https://github.com/m-clark/confusionMatrix}{m-clark/confusion_matrix}).
}
