% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_factor.R
\name{as_factor}
\alias{as_factor}
\alias{to_factor}
\alias{as_factor.data.frame}
\title{Convert variable into factor and keep value labels}
\usage{
as_factor(x, ...)

to_factor(x, ...)

\method{as_factor}{data.frame}(x, ..., add.non.labelled = FALSE)
}
\arguments{
\item{x}{A vector or data frame.}

\item{...}{Optional, unquoted names of variables that should be selected for
further processing. Required, if \code{x} is a data frame (and no
vector) and only selected variables from \code{x} should be processed.
You may also use functions like \code{:} or tidyselect's select-helpers.
See 'Examples'.}

\item{add.non.labelled}{Logical, if \code{TRUE}, non-labelled values also
get value labels.}
}
\value{
A factor, including variable and value labels. If \code{x}
          is a data frame, the complete data frame \code{x} will be returned,
          where variables specified in \code{...} are coerced
          to factors (including variable and value labels);
          if \code{...} is not specified, applies to all variables in the
          data frame.
}
\description{
This function converts a variable into a factor, but preserves
               variable and value label attributes.
}
\details{
\code{as_factor} converts numeric values into a factor with numeric
           levels. \code{\link{as_label}}, however, converts a vector into
           a factor and uses value labels as factor levels.
}
\note{
This function is intended for use with vectors that have value and variable
       label attributes. Unlike \code{\link{as.factor}}, \code{as_factor} converts
       a variable into a factor and preserves the value and variable label attributes.
       \cr \cr
       Adding label attributes is automatically done by importing data sets
       with one of the \code{read_*}-functions, like \code{\link{read_spss}}.
       Else, value and variable labels can be manually added to vectors
       with \code{\link{set_labels}} and \code{\link{set_label}}.
}
\examples{
if (require("sjmisc") && require("magrittr")) {
  data(efc)
  # normal factor conversion, loses value attributes
  x <- as.factor(efc$e42dep)
  frq(x)

  # factor conversion, which keeps value attributes
  x <- as_factor(efc$e42dep)
  frq(x)

  # create partially labelled vector
  x <- set_labels(
    efc$e42dep,
    labels = c(
      `1` = "independent",
      `4` = "severe dependency",
      `9` = "missing value"
   ))

  # only copy existing value labels
  as_factor(x) \%>\% head()
  get_labels(as_factor(x), values = "p")

  # also add labels to non-labelled values
  as_factor(x, add.non.labelled = TRUE) \%>\% head()
  get_labels(as_factor(x, add.non.labelled = TRUE), values = "p")


  # easily coerce specific variables in a data frame to factor
  # and keep other variables, with their class preserved
  as_factor(efc, e42dep, e16sex, c172code) \%>\% head()

  # use select-helpers from dplyr-package
  if (require("dplyr")) {
    as_factor(efc, contains("cop"), c161sex:c175empl) \%>\% head()
  }
}
}
