% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-from-simulation.R
\name{output}
\alias{output}
\title{Get one or more outputs from a simulation}
\usage{
output(sim, ..., subset = NULL, index, methods, reference = FALSE)
}
\arguments{
\item{sim}{a simulation object}

\item{...}{logical conditions to specify a subset of models.  Conditions can
only involve params of model that have length 1 and are of class
numeric or character.}

\item{subset}{a vector of integers indexing the models or a vector of model
names. To select models based on parameter values, use \code{...}.
However, using \code{...} is slower than using subset.}

\item{index}{a vector of positive integers specifying which draws' objects
are desired. If missing, then all draws' outputs are returned.}

\item{methods}{character vector of method names of interest.  If missing,
then all methods' outputs are returned}

\item{reference}{whether to return the ModelRef or the Model object itself}
}
\description{
Returns either the output object itself or a reference to it.
}
\examples{
\dontrun{
 # suppose previously we had run the following:
 sim <- new_simulation(name = "normal-example",
                       label = "Normal Mean Estimation",
                       dir = tempdir()) \%>\%
   generate_model(make_my_example_model, n = 20) \%>\%
   simulate_from_model(nsim = 50, index = 1:3) \%>\%
   run_method(my_example_method)
 # then we could get the method's output as follows:
 o <- output(sim)
 o@out$r1.1 # first random draw's output
 }
}
