% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelFit.R
\name{irefit}
\alias{irefit}
\title{Iterative refitting}
\usage{
irefit(
  network,
  func,
  tol,
  rank = "none",
  connected = FALSE,
  directed = FALSE,
  per = 0.5
)
}
\arguments{
\item{network}{Weighted adjacency matrix, weighted \code{igraph} network, or edge list formatted | n1 | n2 | weight | with colnames \code{c("n1", "n2", "weight")}.}

\item{func}{Model function whose input is the network and whose output is a single real value or a list of reevaluated weights in the first index and a real value in the second.\cr
A wrapper function may have to be written.}

\item{tol}{Allowed error around the original output of \code{func} approximated by the sparsified network within which edges are removed. Specifies if method converges.}

\item{rank}{Ranking of edges. Lower ranked edges are removed first. Must be the same length as \code{nrow(E_List)}.}

\item{connected}{If TRUE, connectivity of the network is prioritized over scoring by \code{func}.}

\item{directed}{If \code{TRUE}, specifies that the inputted network is directed. Default is \code{FALSE}.}

\item{per}{Percentage of edges to add/remove from the sparsifier at each step.}
}
\value{
Sparsified network, \code{H}, which still maintains evaluator function, \code{func}, plus/minus \code{tol}.
}
\description{
Iterative sparsifcation based refitting.
}
\examples{
#Set scoring function
mean.weight.degree <- function(graph){
graph.ob <- igraph::graph_from_edgelist(graph[,1:2])
igraph::E(graph.ob)$weight <- graph[,3]
return(mean(igraph::strength(graph.ob)))
}

#Generate random graph
g <- igraph::erdos.renyi.game(100, 0.1)
igraph::E(g)$weight <- rexp(length(igraph::E(g)), rate=10) #random edge weights from exp(10)
E_List <- cbind(igraph::as_edgelist(g), igraph::E(g)$weight)
colnames(E_List) <- c("n1", "n2", "weight")
sparse_dist <- simplifyNet::irefit(E_List, func=mean.weight.degree, tol = 0.1)
}
\author{
Alexander Mercier

Andrew Kramer
}
