% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3_simaerep.R
\name{plot.simaerep}
\alias{plot.simaerep}
\title{plot AE under-reporting simulation results}
\usage{
\method{plot}{simaerep}(
  x,
  ...,
  study = NULL,
  what = c("prob", "med75"),
  n_sites = 16,
  df_visit = NULL,
  env = parent.frame(),
  plot_event = x$event_names[1]
)
}
\arguments{
\item{x}{simaerep object}

\item{...}{additional parameters passed to \link[=plot_study]{plot_study()} or
\link[=plot_visit_med75]{plot_visit_med75()}}

\item{study}{character specifying study to be plotted, Default: NULL}

\item{what}{one of c("ur", "med75"), specifying whether to plot site AE
under-reporting or visit_med75 values, Default: 'ur'}

\item{n_sites}{number of sites to plot, Default: 16}

\item{df_visit}{optional, pass original visit data if it cannot be retrieved
from parent environment, Default: NULL}

\item{env}{optional, pass environment from which to retrieve original visit
data, Default: parent.frame()}

\item{plot_event}{vector containing the events that should be plotted, default = "ae"}
}
\value{
ggplot object
}
\description{
generic plot function for simaerep objects
}
\details{
see \link[=plot_study]{plot_study()} and
\link[=plot_visit_med75]{plot_visit_med75()}
}
\examples{
\donttest{
df_visit <- sim_test_data_study(
  n_pat = 100,
  n_sites = 5,
  ratio_out = 0.4,
  factor_event_rate = - 0.6
)

evrep <- simaerep(df_visit)

plot(evrep, what = "prob", study = "A")
plot(evrep, what = "med75", study = "A")
}
}
