% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genItemBankInt.R
\name{genItemBankInt}
\alias{genItemBankInt}
\title{Generate item bank for NEAT with internal anchor items}
\usage{
genItemBankInt(C, J, t.tot, min.a, max.a, mu.b, sd.b, leading0 = TRUE,
  num.digits = 4, linkage.plan = NULL, ...)
}
\arguments{
\item{C}{number of common items between two test}

\item{J}{number of total items (unique + common) per test}

\item{t.tot}{number of tests}

\item{min.a}{Lower bound for the (uniform) distribution of item
discrimination parameter}

\item{max.a}{Upper bound for the (uniform) distribution of item
discrimination parameter}

\item{mu.b}{Mean of (normally-distributed) item difficulty parameter}

\item{sd.b}{Standard deviation of (normally-distributed) item difficulty
parameter}

\item{leading0}{format item names with leading zeros for better ordering?}

\item{num.digits}{number of digits for representing items}

\item{linkage.plan}{square matrix or order t.tot representing the number of
items each form has in common with another form. If NULL, links between
forms will be chosen randomly.}

\item{...}{parameters to pass to child functions}
}
\value{
list containing 2PL item parameters per form
}
\description{
Generate item bank for NEAT with internal anchor items
}
